/*
*   \file
*   \remarks Device store (DRM Core) APIs Prototypes
*   \author Pavel Haber
*
*   WMDRM Service Package, Type Definitions, Device store (DRM Core)
*
*   Copyright (C) 2007 by Discretix Technologies Ltd.
*           All rights reserved.
*
*/

#ifndef DEVICESTORE_TST_API_H
#define DEVICESTORE_TST_API_H

DRM_RESULT DS_PreTestCase(long lTCID, char *strTCName);
DRM_RESULT DS_PostTestCase(long lTCID, char *strTCName);

#if DRM_SUPPORT_DEVICESTORE
DRM_RESULT TestDeviceStoreRegisterDevice(long argc, char **argv);
DRM_RESULT TestDeviceStoreUnRegisterDevice(long argc, char **argv);
DRM_RESULT TestDeviceStoreCommitDevice(long argc, char **argv);
DRM_RESULT TestDeviceStoreFreeDevice(long argc, char **argv);
DRM_RESULT TestDeviceStoreGetDeviceByID(long argc, char **argv);
DRM_RESULT TestDeviceStoreGetFirstDevice(long argc, char **argv);
DRM_RESULT TestDeviceStoreGetNextDevice(long argc, char **argv);
DRM_RESULT TestDeviceStoreGetDeviceID(long argc, char **argv);
DRM_RESULT TestDeviceStoreSetDeviceAttr(long argc, char **argv);
DRM_RESULT TestDeviceStoreGetDeviceAttr(long argc, char **argv);
DRM_RESULT TestDeviceStoreGetDeviceAttrByIndex(long argc, char **argv);
DRM_RESULT TestDeviceStoreGetDeviceAttrCount(long argc, char **argv);
DRM_RESULT TestDeviceStoreChangeTime(long argc, char **argv);
DRM_RESULT TestDeviceStoreInitialize(long argc, char **argv);
DRM_RESULT TestDeviceStoreUninitialize(long argc, char **argv);
DRM_RESULT TestDeviceStoreRegisterManyDevices(long argc, char **argv);
DRM_RESULT TestDeviceStoreUnRegisterManyDevices(long argc, char **argv);
DRM_RESULT TestDeviceStoreSetManyAttr(long argc, char **argv);
DRM_RESULT TestDeviceStoreGetManyAttr(long argc, char **argv);
#endif

#endif

